;; This example will install a RSX command which can be used
;; to get and put a boot sector to a SYSTEM/VENDOR disc.
;;
;; The boot sector can be executed with a |CPM command.
;;

.kl_find_command	equ	&bcd4
.kl_log_ext			equ	&bcd1	

;; call &8000 to install RSX commands:
;;
;; |BOOTGET,<drive>,<addr>
;; get track 0, sector &41 on drive <drive> and write it to <addr>
;;
;; |BOOTPUT,<drive>,<addr>
;; put track 0, sector &41 on drive <drive> and read from <addr>

;;------------------------------------------------------------
;; install rsx commands

org &8000

.start	
		ld hl,work_space
		ld bc,rsx_table
		jp	kl_log_ext

;;------------------------------------------------------------

.work_space
		defs 4

;;------------------------------------------------------------

.rsx_table
		defw	name_table
		jp		get_boot_sector			;; get boot sector
		jp		put_boot_sector			;; put boot sector

;;------------------------------------------------------------

.name_table
		defb	"BOOTGE","T"+&80		// get boot sector
		defb	"BOOTPU","T"+&80		// put boot sector
		defb	0

;;------------------------------------------------------------
		
.get_boot_sector
		cp 2
		ret nz
.ok
		call	initialise
		ret nc
	
		ld l,(ix+0)						;; address to put boot sector data to
		ld h,(ix+1)

		ld e,(ix+2)						;; drive 
		
		ld d,0							;; track
		ld c,&41						;; sector
		rst 3
		defw read_sector_jmp
		ret

.put_boot_sector
		cp 2
		ret nz
		
		call initialise
		ret nc

		ld l,(ix+0)						;; address to get boot sector data from
		ld h,(ix+1)
		
		ld e,(ix+2)						;; drive

		ld d,0
		ld c,&41
		rst 3
		defw write_sector_jmp

		ret

;;--------------------------------------------------------------
;; find commands
		
.initialise
		ld hl,read_sector_cmd
		call kl_find_command		
		ret nc
		ld (read_sector_jmp),hl
		ld a,b
		ld (read_sector_jmp+2),a

		ld hl,write_sector_cmd
		call kl_find_command
		ret nc
		ld (write_sector_jmp),hl
		ld a,b
		ld (write_sector_jmp+2),a
		ret
						
;;--------------------------------------------------------------
		
.read_sector_cmd
		defb 4+&80				;; BIOS: READ SECTOR
.write_sector_cmd
		defb 5+&80				;; BIOS: WRITE SECTOR

.read_sector_jmp
		defw	0				;; address
		defb 	0				;; rom select

.write_sector_jmp
		defw	0				;; address
		defb	0				;; rom select
